<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Panel SiPerpus | Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" href="{{ asset('assets/mm.svg') }}">

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('assets/admin/plugins/fontawesome-free/css/all.min.css') }}">

    <!-- AdminLTE -->
    <link rel="stylesheet" href="{{ asset('assets/admin/dist/css/adminlte.min.css') }}">

    <style>
        body {
            font-family: 'Inter', sans-serif;
            height: 100vh;
            margin: 0;
            background: linear-gradient(270deg, #667eea, #764ba2, #ff416c);
            background-size: 600% 600%;
            animation: gradientMove 15s ease infinite;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @keyframes gradientMove {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .login-box {
            width: 400px;
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.18);
            backdrop-filter: blur(18px);
            border-radius: 22px;
            box-shadow: 0 40px 80px rgba(0, 0, 0, 0.35);
            overflow: hidden;
            border: 1px solid rgba(255, 255, 255, 0.25);
        }

        .glass-header {
            padding: 35px 20px;
            text-align: center;
            background: linear-gradient(135deg, #ff416c, #ff4b2b);
        }

        .glass-header img {
            width: 170px;
            filter: drop-shadow(0 8px 15px rgba(0, 0, 0, 0.4));
            transition: transform 0.4s ease;
        }

        .glass-header img:hover {
            transform: scale(1.08) rotate(-1deg);
        }

        .glass-body {
            padding: 35px 30px;
            background: rgba(255, 255, 255, 0.92);
        }

        .login-title {
            font-weight: 600;
            text-align: center;
            color: #444;
            margin-bottom: 25px;
        }

        .floating-group {
            position: relative;
            margin-bottom: 25px;
        }

        .floating-group input {
            width: 100%;
            padding: 14px 14px;
            border-radius: 14px;
            border: 1px solid #ddd;
            outline: none;
            background: transparent;
            font-size: 15px;
        }

        .floating-group label {
            position: absolute;
            top: 50%;
            left: 14px;
            color: #999;
            font-size: 14px;
            transform: translateY(-50%);
            pointer-events: none;
            transition: 0.3s;
            background: #fff;
            padding: 0 6px;
        }

        .floating-group input:focus + label,
        .floating-group input:not(:placeholder-shown) + label {
            top: -8px;
            font-size: 12px;
            color: #667eea;
        }

        .btn-glow {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: #fff;
            border: none;
            border-radius: 16px;
            padding: 12px;
            font-weight: 600;
            box-shadow: 0 0 0 rgba(102, 126, 234, 0.6);
            transition: all 0.4s ease;
        }

        .btn-glow:hover {
            box-shadow: 0 0 25px rgba(102, 126, 234, 0.8);
            transform: translateY(-2px);
        }

        .btn-outline-modern {
            border-radius: 14px;
            font-weight: 500;
            padding: 10px;
        }

        .alert {
            border-radius: 14px;
            font-size: 14px;
        }

        .footer-links a {
            font-size: 14px;
            text-decoration: none;
        }
    </style>
</head>

<body>

    <div class="login-box">
        <div class="glass-card">

            <div class="glass-header">
                <img src="{{ asset('assets/publics/ramizah.png') }}">
            </div>

            <div class="glass-body">

                <div class="login-title">
                    Selamat Datang 👋 <br>
                    <small>Silakan login untuk melanjutkan</small>
                </div>

                @if (session()->has('msgError'))
                    <div class="alert alert-danger text-center">
                        {{ session()->get('msgError') }}
                    </div>
                @endif

                <form action="{{ route('login') }}" method="post">
                    @csrf

                    <div class="floating-group">
                        <input type="text" name="username" required placeholder=" ">
                        <label><i class="fas fa-user mr-1"></i> Username</label>
                    </div>

                    <div class="floating-group">
                        <input type="password" name="password" required placeholder=" ">
                        <label><i class="fas fa-lock mr-1"></i> Password</label>
                    </div>

                    <button type="submit" class="btn btn-glow btn-block">
                        <i class="fas fa-sign-in-alt mr-1"></i> Login
                    </button>
                </form>

                <hr>

                <div class="footer-links">
                    <a href="/daftar" class="btn btn-outline-primary btn-block btn-outline-modern">
                        <i class="fas fa-user-plus mr-1"></i> Daftar Member
                    </a>

                    <a href="/home" class="btn btn-outline-danger btn-block btn-outline-modern">
                        <i class="fas fa-home mr-1"></i> Kembali ke Beranda
                    </a>
                </div>

            </div>
        </div>
    </div>

    <script src="{{ asset('assets/admin/plugins/jquery/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/admin/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/admin/dist/js/adminlte.min.js') }}"></script>

</body>

</html>
